<?php
$page = "New Customer Registration";
$page_url = "New_Registration";
include_once 'includes/header.php';
include_once 'includes/sidemenu.php'; // Note: If sidemenu.php contains sidebar content, ensure it’s removed or empty

// Open db connection
$db = new mysqli_ext($db_hostname, $db_username, $db_password, $db_database);
$db->set_charset("utf8");

$ad = new UserProfile($db);
$dashboard = new MarketplaceDashboard($db);
$all_products = $dashboard->getAllProductsSalesAdmin();

$products = [
    ['id' => 1, 'name' => 'Premium Max+ Plan', 'price' => 45231.89],
    ['id' => 2, 'name' => 'Installation', 'price' => 45231.89],
    ['id' => 3, 'name' => 'Battery Pack', 'price' => 45231.89],
];
?>

<style>
    .main-content {
        margin-left: 230px;
        padding: 0;
        min-height: 100vh;
        background-color: white;
    }

    .header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        background: white;
        border-bottom: 1px solid #ccc;
        padding: 20px;
        position: sticky;
        top: 0;
        z-index: 999;
    }

    h2 {
        font-size: 23px;

    }

    .page-title {
        font-size: 23px;
        font-weight: 500;
        margin: 0;
    }

    .main-content-container {
        padding: 20px;
    }

    .plans-section {
        padding: 20px;
    }

    .plans-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 24px;
        margin-top: 20px;
    }

    .plan-card {
        background: white;
        border-radius: 12px;
        padding: 24px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        cursor: pointer;
        transition: transform 0.2s, box-shadow 0.2s;
        position: relative;
    }

    .plan-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    }

    .plan-icon-select {
        display: flex;
        align-items: center;
        gap: 12px;
        margin-bottom: 16px;
    }

    .plan-icon {
        font-size: 32px;
    }

    .circle-dot {
        width: 24px;
        height: 24px;
        border: 2px solid #4285f4;
        border-radius: 50%;
        background: transparent;
        position: relative;
    }

    .plan-card.selected .circle-dot::after {
        content: "";
        width: 12px;
        height: 12px;
        background: #4285f4;
        border-radius: 50%;
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
    }

    .plan-title {
        font-size: 20px;
        font-weight: 600;
        color: #1a1a1a;
        margin-bottom: 8px;
    }

    .plan-description {
        color: #666;
        font-size: 14px;
        line-height: 1.5;
    }

    .category-plans-section {
        margin-top: 20px;
    }

    .back-button {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        color: #4285f4;
        text-decoration: none;
        font-weight: 500;
        margin-bottom: 20px;
    }

    .plans-title {
        font-size: 24px;
        font-weight: 600;
        color: #1a1a1a;
        margin-bottom: 20px;
    }

    .plan-detail-card {
        background: white;
        border-radius: 0.375rem;
        color: white;
        position: relative;
        overflow: hidden;
    }

    .plan-detail-header {
        border-radius: 0.375rem;
        background: linear-gradient(to bottom, #185de0, #e73333);
        padding: 1.25rem;
    }

    .plan-detail-card::before {
        content: "";
        position: absolute;
        top: -50%;
        right: -50%;
        width: 100%;
        height: 100%;
        background: linear-gradient(45deg, transparent, rgba(255, 255, 255, 0.1), transparent);
        transform: rotate(45deg);
    }

    .plan-name {
        font-size: 1.5rem;
        font-weight: bold;
        margin-bottom: 0.5rem;
        color: white !important;
    }

    .plan-speed {
        font-size: 0.9rem;
        margin-bottom: 1rem;
        opacity: 0.9;
    }

    .plan-price {
        font-size: 1.75rem;
        font-weight: bold;
        margin-bottom: 0.25rem;
    }

    .plan-billing {
        font-size: 0.85rem;
        opacity: 0.8;
        margin-bottom: 1rem;
    }

    .plan-detail-header>.plan-description {
        font-size: 0.9rem;
        margin-bottom: 1.5rem;
        opacity: 0.9;
        color: white;
    }

    .plan-features {
        list-style: none;
        color: #444449;
        padding: 1.25rem;
    }

    .plan-features li {
        display: flex;
        align-items: center;
        gap: 0.5rem;
        margin-bottom: 0.5rem;
        font-size: 0.85rem;
    }

    .plan-features li::before {
        content: "✓";
        color: #4285f4;
        position: absolute;
        left: 0;
    }

    .select-plan-btn {
        background: #4285f4;
        color: white;
        border: none;
        padding: 12px;
        border-radius: 8px;
        width: 100%;
        font-size: 16px;
        font-weight: 500;
        cursor: pointer;
        transition: background 0.2s;
    }

    .select-plan-btn:hover {
        background: #3367d6;
    }

    .checkout-container {
        display: flex;
        gap: 24px;
        flex-wrap: wrap;
    }

    .checkout-main {
        flex: 2;
        min-width: 300px;
    }

    .checkout-sidebar {
        flex: 1;
        min-width: 250px;
        background: white;
        border-radius: 12px;
        padding: 24px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    }

    .cart-section,
    .vendor-section,
    .payment-section,
    .order-summary,
    .installation-section {
        background: white;
        border-radius: 12px;
        padding: 24px;
        margin-bottom: 24px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    }

    .cart-header,
    .summary-title,
    .installation-title {
        font-size: 18px;
        font-weight: 600;
        color: #1a1a1a;
        margin-bottom: 16px;
    }

    .cart-items {
        display: flex;
        flex-direction: column;
        gap: 12px;
    }

    .cart-item {
        display: flex;
        align-items: center;
        gap: 12px;
        padding: 12px 0;
        border-bottom: 1px solid #f0f0f0;
    }

    .cart-item:last-child {
        border-bottom: none;
    }

    .cart-item-checkbox {
        width: 20px;
        height: 20px;
    }

    .cart-item-info {
        flex: 1;
        font-size: 16px;
        color: #1a1a1a;
    }

    .cart-item-price {
        font-size: 16px;
        font-weight: 600;
        color: #1a1a1a;
    }

    .section-title {
        font-size: 20px;
        font-weight: 600;
        color: #2c3e50;
        margin-bottom: 20px;
    }

    .filter-tabs {
        display: flex;
        margin-bottom: 20px;
        background-color: #d9e5fc;
        width: fit-content;
        padding: 5px;
        border-radius: 6px;
    }

    .filter-tab {
        padding: 8px 8px;
        border: none;
        background: none;
        cursor: pointer;
        font-size: 14px;
        transition: all 0.3s;
    }

    .filter-tab.active {
        background: white !important;
        border-radius: 20px;
        color: black !important;
    }

    .vendor-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 16px;
    }

    .vendor-name {
        font-size: 18px;
        font-weight: 600;
        color: #1a1a1a;
    }

    .filter-button {
        background: none;
        border: none;
        color: #4285f4;
        font-size: 14px;
        cursor: pointer;
    }

    .products-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 24px;
    }

    .product-card {
        position: relative;
        background: white;
        border-radius: 12px;
        overflow: hidden;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    }

    .product-image img {
        width: 100%;
        height: 150px;
        object-fit: cover;
    }

    .product-info {
        padding: 16px;
    }

    .product-name {
        font-size: 16px;
        font-weight: 600;
        color: #1a1a1a;
        margin-bottom: 8px;
    }

    .product-price {
        font-size: 16px;
        font-weight: 600;
        color: #1a1a1a;
        margin-bottom: 8px;
    }

    .product-rating {
        color: #f4c107;
        font-size: 14px;
    }

    .product-overlay {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(0, 0, 0, 0.7);
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        gap: 12px;
        opacity: 0;
        transition: opacity 0.2s;
    }

    .product-card:hover .product-overlay {
        opacity: 1;
    }

    .overlay-button {
        background: #e74c3c;
        color: white;
        border: none;
        padding: 8px 16px;
        border-radius: 8px;
        cursor: pointer;
        font-size: 14px;
    }

    .overlay-button.view-button {
        background: #4285f4;
    }

    .installation-header {
        display: flex;
        align-items: center;
        gap: 12px;
        margin-bottom: 16px;
    }

    .location-icon {
        font-size: 20px;
    }

    .address-input {
        width: 100%;
        padding: 12px;
        border: 1px solid #e1e5e9;
        border-radius: 8px;
        font-size: 14px;
        margin-bottom: 12px;
    }

    .address-details {
        color: #666;
        font-size: 14px;
    }

    .payment-options {
        display: flex;
        flex-direction: column;
        gap: 12px;
        margin-bottom: 24px;
    }

    .payment-option {
        padding: 12px;
        border: 1px solid #e1e5e9;
        border-radius: 8px;
        cursor: pointer;
        font-size: 14px;
        color: #666;
    }

    .payment-option.selected {
        border-color: #4285f4;
        background: rgba(66, 133, 244, 0.1);
        color: #4285f4;
    }

    .summary-row {
        display: flex;
        justify-content: space-between;
        font-size: 14px;
        color: #666;
        margin-bottom: 12px;
    }

    .summary-row.total {
        font-weight: 600;
        color: #1a1a1a;
    }

    .checkout-button {
        background: #4285f4;
        color: white;
        border: none;
        padding: 12px;
        border-radius: 8px;
        width: 100%;
        font-size: 16px;
        font-weight: 500;
        cursor: pointer;
        transition: background 0.2s;
    }

    .checkout-button:hover {
        background: #3367d6;
    }

    .modal {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.5);
        justify-content: center;
        align-items: center;
        z-index: 1000;
    }

    .modal-content {
        background: white;
        border-radius: 12px;
        padding: 24px;
        max-width: 800px;
        width: 90%;
        max-height: 80vh;
        overflow-y: auto;
        position: relative;
    }

    .modal-close {
        position: absolute;
        top: 16px;
        right: 16px;
        background: none;
        border: none;
        font-size: 20px;
        cursor: pointer;
    }

    .modal-product-section {
        display: flex;
        gap: 24px;
        flex-wrap: wrap;
    }

    .modal-product-images {
        flex: 1;
        min-width: 200px;
    }

    .modal-main-image img {
        width: 100%;
        border-radius: 8px;
    }

    .modal-thumbnail-images {
        display: flex;
        gap: 8px;
        margin-top: 8px;
    }

    .modal-thumbnail img {
        width: 60px;
        height: 60px;
        border-radius: 8px;
        cursor: pointer;
    }

    .modal-product-details {
        flex: 1;
        min-width: 200px;
    }

    .modal-product-title {
        font-size: 20px;
        font-weight: 600;
        color: #1a1a1a;
        margin-bottom: 16px;
    }

    .modal-price-section {
        display: flex;
        flex-direction: column;
        gap: 8px;
        margin-bottom: 16px;
    }

    .modal-price {
        font-size: 18px;
        font-weight: 600;
        color: #1a1a1a;
    }

    .modal-power-info {
        color: #666;
        font-size: 14px;
    }

    .modal-rating {
        display: flex;
        align-items: center;
        gap: 8px;
        margin-bottom: 16px;
    }

    .modal-stars {
        color: #f4c107;
        font-size: 14px;
    }

    .modal-rating-text {
        color: #666;
        font-size: 14px;
    }

    .modal-product-description {
        color: #666;
        font-size: 14px;
        margin-bottom: 16px;
    }

    .modal-quantity-section {
        display: flex;
        align-items: center;
        gap: 16px;
        margin-bottom: 16px;
    }

    .modal-quantity-label {
        font-size: 14px;
        font-weight: 600;
        color: #1a1a1a;
    }

    .modal-quantity-controls {
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .modal-quantity-btn {
        background: #e1e5e9;
        border: none;
        padding: 8px 12px;
        border-radius: 8px;
        cursor: pointer;
        font-size: 14px;
    }

    .modal-quantity-input {
        width: 60px;
        padding: 8px;
        border: 1px solid #e1e5e9;
        border-radius: 8px;
        text-align: center;
    }

    .modal-stock-info {
        color: #666;
        font-size: 14px;
    }

    .modal-add-to-cart {
        background: #e74c3c;
        color: white;
        border: none;
        padding: 12px;
        border-radius: 8px;
        width: 100%;
        font-size: 16px;
        font-weight: 500;
        cursor: pointer;
        margin-bottom: 16px;
    }

    .modal-section-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        cursor: pointer;
        margin-bottom: 8px;
    }

    .modal-section-title {
        font-size: 16px;
        font-weight: 600;
        color: #1a1a1a;
    }

    .modal-section-icon {
        font-size: 16px;
        color: #666;
    }

    .modal-section-content {
        color: #666;
        font-size: 14px;
    }

    .modal-section-content.collapsed {
        display: none;
    }

    .modal-features-list {
        list-style: none;
        padding: 0;
    }

    .modal-features-list li {
        margin-bottom: 8px;
        position: relative;
        padding-left: 20px;
    }

    .modal-features-list li::before {
        content: "✓";
        color: #4285f4;
        position: absolute;
        left: 0;
    }

    .modal-product-type,
    .modal-delivery-info {
        color: #666;
        font-size: 14px;
        margin-bottom: 8px;
    }

    .modal-terms-link {
        color: #4285f4;
        text-decoration: none;
        font-size: 14px;
    }

    .toast {
        visibility: hidden;
        min-width: 250px;
        margin-left: -125px;
        background: #e74c3c;
        color: white;
        text-align: center;
        border-radius: 8px;
        padding: 12px;
        position: fixed;
        z-index: 9999;
        left: 50%;
        bottom: 40px;
        font-size: 16px;
        transition: visibility 0s, opacity 0.5s linear;
        opacity: 0;
    }

    .toast.show {
        visibility: visible;
        opacity: 1;
    }

    .form-group {
        margin-bottom: 15px;
    }

    .form-row {
        display: flex;
        gap: 20px;
        flex-wrap: wrap;
    }

    .form-group label {
        font-weight: 500;
        color: #333;
        margin-bottom: 5px;
        display: block;
    }


    .form-input,
    select,
    textarea {
        width: 100%;
        padding: 10px;
        border: 1px solid #ddd;
        border-radius: 4px;
        font-size: 14px;
    }

    .form-control {
        width: 100%;

        border: 1px solid #ddd;
        border-radius: 4px;
        font-size: 14px;
    }

    .btn-primary {
        background: #4285f4;
        color: white;
        border: none;
        padding: 12px;
        border-radius: 8px;
        font-size: 16px;
        font-weight: 500;
        cursor: pointer;
        transition: background 0.2s;
    }

    .btn-primary:hover {
        background: #3367d6;
    }

    .add-more {
        background: none;
        border: none;
        color: #4285f4;
        font-size: 14px;
        cursor: pointer;
        margin-top: 5px;
    }

    .additional-field {
        display: flex;
        gap: 10px;
        margin-top: 10px;
    }

    .remove-field-btn {
        background: #e74c3c;
        color: white;
        border: none;
        padding: 8px 12px;
        border-radius: 4px;
        cursor: pointer;
    }

    .step {
        display: none;
    }

    .step.active {
        display: block;
    }

    @media (max-width: 768px) {
        .main-content {
            margin-left: 0;
        }

        .plans-grid {
            grid-template-columns: 1fr;
        }

        .checkout-container {
            flex-direction: column;
        }

        .checkout-main,
        .checkout-sidebar {
            width: 100%;
        }
    }
</style>

<div class="main-content">
    <div class="header">
        <h1 class="page-title">New Registration</h1>
    </div>
    <div id="toast" class="toast"></div>


    <div class="main-content-container">

        <!-- <div class="alert alert-danger" id="errPan" style="display:none"></div>
        <div class="alert alert-success" id="succPan" style="display:none"></div> -->

        <!-- Step 1: Network Coverage -->
        <div id="step1" class="step active">
            <h2>Check Prospect Network Coverage</h2>
            <form id="coverageForm">
                <div class="form-group">
                    <label for="city">City/State</label>
                    <select id="city" name="city" class="form-control" required>
                        <option value="">Select Location</option>
                        <!-- Dynamically populated -->
                    </select>
                </div>
                <div class="form-group">
                    <label for="address">Address</label>
                    <input type="text" id="address" name="address" class="form-control" placeholder="Enter Address"
                        required>
                    <ul id="addressSuggestions" class="list-group" style="position: absolute; z-index: 1000;"></ul>

                </div>
                <button type="submit" class="btn-primary">Check Network Coverage</button>
            </form>
            <div id="statusMessage" style="display: none; color: green; margin-top: 10px">
                Coverage available! Proceed to user details.
            </div>
            <div id="unavailableStatusMessage" style="display: none; color: red; margin-top: 10px">
                Sorry, we do not have coverage in this location yet.
                <a href="#" onclick="changeLocation()">Try another location</a>.
            </div>
        </div>

        <!-- Step 2: User Details -->
        <div id="step2" class="step">
            <h2>Enter User Details</h2>
            <form id="userDetailsForm">
                <div class="form-row">
                    <div class="form-group">
                        <label for="fullName">Full Name *</label>
                        <input type="text" id="fullName" name="fullName" class="form-control" placeholder="Your Name"
                            value="<?= htmlspecialchars($customer['name'] ?? '') ?>" required>
                    </div>
                    <div class="form-group">
                        <label for="companyName">Company Name</label>
                        <input type="text" id="companyName" name="companyName" class="form-control"
                            placeholder="Your Company Name"
                            value="<?= htmlspecialchars($customer['company_name'] ?? '') ?>">
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group">
                        <label for="phone">Phone *</label>
                        <input type="tel" id="phone" name="phone" class="form-control" placeholder="Your Phone Number"
                            value="<?= htmlspecialchars($customer['phone'] ?? '') ?>" required>
                        <button type="button" class="add-more" onclick="addPhoneField()">+ Add more Phone
                            Number</button>
                        <div id="additionalPhones"></div>
                    </div>
                    <div class="form-group">
                        <label for="email">Email *</label>
                        <input type="email" id="email" name="email" class="form-control" placeholder="Your Email"
                            value="<?= htmlspecialchars($customer['email'] ?? '') ?>" required>
                        <button type="button" class="add-more" onclick="addEmailField()">+ Add more Email</button>
                        <div id="additionalEmails"></div>
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group">
                        <label for="fullAddress">Full Address</label>
                        <input type="text" id="fullAddress" name="fullAddress" class="form-control"
                            placeholder="Your Full Address" value="<?= htmlspecialchars($customer['address'] ?? '') ?>">
                    </div>
                    <div class="form-group">
                        <label for="howDidYouHear">How did you hear about us?</label>
                        <select id="howDidYouHear" name="howDidYouHear" class="form-control">
                            <option value="">-- Select --</option>
                            <option value="social" <?= (!empty($customer['source']) && $customer['source'] == 'social') ? 'selected' : '' ?>>Social Media</option>
                            <option value="referral" <?= (!empty($customer['source']) && $customer['source'] == 'referral') ? 'selected' : '' ?>>Referral</option>
                            <option value="ads" <?= (!empty($customer['source']) && $customer['source'] == 'ads') ? 'selected' : '' ?>>Ads</option>
                            <option value="other" <?= (!empty($customer['source']) && $customer['source'] == 'other') ? 'selected' : '' ?>>Other</option>
                        </select>
                    </div>
                </div>
                <div class="form-group">
                    <label for="comments">Any comment</label>
                    <textarea id="comments" name="comments" class="form-control" placeholder="Additional Comment"
                        rows="4"><?= htmlspecialchars($customer['comment'] ?? '') ?></textarea>
                </div>
                <button type="submit" class="btn-primary">Proceed to Select Plan</button>
            </form>
        </div>

        <!-- Step 3: Service Plans -->
        <div id="step3" class="step">
            <h2>Select a Service Plan</h2>
            <section class="plans-section">
                <div class="plans-grid">
                    <div class="plan-card residential-card" onclick="selectPlan('residential')">
                        <div class="plan-icon-select">
                            <div class="plan-icon">🏠</div>
                            <div class="circle-dot"></div>
                        </div>
                        <h3 class="plan-title">Residential Plan</h3>
                        <p class="plan-description">
                            Tailored for homes and personal use. Enjoy reliable, high-speed internet for streaming,
                            browsing, video calls, and smart home devices — all at affordable rates.
                        </p>
                    </div>
                    <div class="plan-card business-card" onclick="selectPlan('business')">
                        <div class="plan-icon-select">
                            <div class="plan-icon">🏢</div>
                            <div class="circle-dot"></div>
                        </div>
                        <h3 class="plan-title">Business Plan</h3>
                        <p class="plan-description">
                            Designed for offices and enterprises. Get fast, scalable internet with dedicated
                            bandwidth, uptime guarantees, and priority support to keep your business running
                            smoothly.
                        </p>
                    </div>
                </div>
            </section>
            <section class="category-plans-section" id="categoryPlans" style="display: none">
                <a href="#" class="back-button" onclick="goBackToPlans()">
                    <span>←</span> Go Back
                </a>
                <h2 class="plans-title" id="plansTitle">Plans For You</h2>
                <div class="plans-grid" id="plansContainer">
                    <!-- Plans will be dynamically loaded here -->
                </div>
            </section>
        </div>

        <!-- Step 4: Checkout -->
        <div id="step4" class="step">
            <h2>Checkout</h2>
            <div class="checkout-container">
                <div class="checkout-main">
                    <div class="cart-section">
                        <div class="cart-header">
                            Cart (<span id="cartItemCount">0</span> Items)
                        </div>
                        <div class="cart-items" id="cartItems">
                            <!-- Cart items will be dynamically populated -->
                        </div>
                    </div>
                    <div class="section-title">Recommended Add-Ons</div>
                    <div class="filter-tabs">
                        <button class="filter-tab active" onclick="switchTab(this, 'all')">All</button>
                        <button class="filter-tab" onclick="switchTab(this, 'fiberone')">From Fiberone</button>
                        <button class="filter-tab" onclick="switchTab(this, 'third-party')">Third party
                            Vendors</button>
                    </div>
                    <div class="vendor-section" id="fiberone-section">
                        <div class="vendor-header">
                            <div class="vendor-name">From Fiberone</div>
                            <button class="filter-button">Filter <span>≡</span></button>
                        </div>
                        <div class="products-grid">
                            <?php if (!empty($all_products['fob'])): ?>
                                <?php foreach ($all_products['fob'] as $product): ?>
                                    <div class="product-card" data-product-id="<?= htmlspecialchars($product->id) ?>">
                                        <div class="product-image">
                                            <img src="../assets/images/wifi-range-img3.png"
                                                alt="<?= htmlspecialchars($product->name) ?>" width="100%">
                                        </div>
                                        <div class="product-info">
                                            <div class="product-name"><?= htmlspecialchars($product->name) ?></div>
                                            <div class="product-price">₦<?= number_format($product->price, 2) ?></div>
                                            <div class="product-rating">★★★★★</div>
                                        </div>
                                        <div class="product-overlay">
                                            <button class="overlay-button view-button" onclick="viewProduct(this)">View</button>
                                            <button class="overlay-button add-to-cart-button" onclick="addToCart(this)">Add
                                                to Cart</button>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <p>No FOB products available.</p>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="vendor-section" id="third-party-section">
                        <div class="vendor-header">
                            <div class="vendor-name">From Third Party Vendor</div>
                            <button class="filter-button">Filter <span>≡</span></button>
                        </div>
                        <div class="products-grid">
                            <?php if (!empty($all_products['third_party'])): ?>
                                <?php foreach ($all_products['third_party'] as $product): ?>
                                    <div class="product-card" data-product-id="<?= htmlspecialchars($product->id) ?>">
                                        <div class="product-image">
                                            <img src="../assets/images/wifi-range-img3.png"
                                                alt="<?= htmlspecialchars($product->name) ?>" width="100%">
                                        </div>
                                        <div class="product-info">
                                            <div class="product-name"><?= htmlspecialchars($product->name) ?></div>
                                            <div class="product-price">₦<?= number_format($product->price, 2) ?></div>
                                            <div class="product-rating">★★★★★</div>
                                        </div>
                                        <div class="product-overlay">
                                            <button class="overlay-button view-button" onclick="viewProduct(this)">View</button>
                                            <button class="overlay-button add-to-cart-button" onclick="addToCart(this)">Add
                                                to Cart</button>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <p>No third-party products available.</p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="checkout-sidebar">
                    <div class="installation-section">
                        <div class="installation-header">
                            <div class="location-icon">📍</div>
                            <div class="installation-title">Installation Address</div>
                        </div>
                        <input type="text" class="address-input" id="installationAddress"
                            placeholder="Enter Installation Address">
                        <div class="address-details" id="addressDetails"></div>
                    </div>
                    <div class="payment-section">
                        <div class="section-title">Payment</div>
                        <div class="payment-options">
                            <div class="payment-option selected" onclick="selectPayment(this)">💳 Pay with card
                            </div>
                            <div class="payment-option" onclick="selectPayment(this)">💸 Pay with transfer</div>
                        </div>
                    </div>
                    <div class="order-summary">
                        <div class="summary-title">Order Summary</div>
                        <div class="summary-row">
                            <span>Subtotal</span>
                            <span id="subtotal">₦0.00</span>
                        </div>
                        <div class="summary-row">
                            <span>Delivery fee</span>
                            <span id="deliveryFee">₦15.00</span>
                        </div>
                        <div class="summary-row total">
                            <span>Total</span>
                            <span id="total">₦15.00</span>
                        </div>
                    </div>
                    <button class="checkout-button" onclick="proceedToPayment()">Generate Payment Link</button>

                    <div id="orderDetails"
                        style="display:none; margin-top:20px; background:#f9f9f9; border-radius:8px; padding:16px; border:1px solid #e1e5e9;">
                        <h3 style="color:#185de0;">Order Created Successfully!</h3>
                        <!-- <div><strong>Customer ID:</strong> <span id="orderCustomerId"></span></div>
                        <div><strong>Order ID:</strong> <span id="orderOrderId"></span></div> -->
                        <div><strong>Order Number:</strong> <span id="orderOrderNumber"></span></div>
                        <div><strong>Checkout Link:</strong> <a id="orderCheckoutLink" href="#" target="_blank"></a>
                        </div>
                    </div>


                </div>
            </div>
            <div class="modal" id="productModal">
                <div class="modal-content">
                    <button class="modal-close" onclick="closeModal()">×</button>
                    <div class="modal-product-section">
                        <div class="modal-product-images">
                            <div class="modal-main-image">
                                <img src="../assets/images/wifi-range-img3.png" alt="Product" width="100%"
                                    id="modalMainImage">
                            </div>
                            <div class="modal-thumbnail-images">
                                <div class="modal-thumbnail">
                                    <img src="../assets/images/wifi-range-img.png" alt="Thumbnail 1" width="100%"
                                        onclick="changeModalImage(this.src)">
                                </div>
                                <div class="modal-thumbnail">
                                    <img src="../assets/images/wifi-range-img2.png" alt="Thumbnail 2" width="100%"
                                        onclick="changeModalImage(this.src)">
                                </div>
                            </div>
                        </div>
                        <div class="modal-product-details">
                            <h1 class="modal-product-title">AC1200 Wireless WiFi Extender</h1>
                            <div class="modal-price-section">
                                <div class="modal-price">₦37,500.00</div>
                                <div class="modal-power-info">Power Input: AC110V - AC240V</div>
                            </div>
                            <div class="modal-rating">
                                <div class="modal-stars">★★★★★</div>
                                <div class="modal-rating-text">(5 reviews)</div>
                            </div>
                            <div class="modal-product-description">
                                Boost your internet coverage today with FiberOne's T45Q Lightning Speed WiFi
                                Extender.
                            </div>
                            <div class="modal-quantity-section">
                                <div class="modal-quantity-label">QUANTITY</div>
                                <div class="modal-quantity-controls">
                                    <button class="modal-quantity-btn" onclick="decreaseModalQuantity()">-</button>
                                    <input type="number" class="modal-quantity-input" value="1" min="1"
                                        id="modalQuantity">
                                    <button class="modal-quantity-btn" onclick="increaseModalQuantity()">+</button>
                                </div>
                                <div class="modal-stock-info">331 in stock</div>
                            </div>
                            <button class="modal-add-to-cart" onclick="addToCartFromModal()">Add to Cart</button>
                            <div class="modal-product-sections">
                                <div class="modal-section">
                                    <div class="modal-section-header" onclick="toggleModalSection('expect')">
                                        <div class="modal-section-title">What You Can Expect</div>
                                        <div class="modal-section-icon" id="modal-expect-icon">−</div>
                                    </div>
                                    <div class="modal-section-content" id="modal-expect-content">
                                        Saying goodbye to frustrating dead zones and enjoying seamless connectivity
                                        throughout your home and offices. It extends the reach of our high-speed
                                        internet service, ensuring a reliable connection in every corner.
                                    </div>
                                </div>
                                <div class="modal-section">
                                    <div class="modal-section-header" onclick="toggleModalSection('love')">
                                        <div class="modal-section-title">Why You Will Love It</div>
                                        <div class="modal-section-icon" id="modal-love-icon">−</div>
                                    </div>
                                    <div class="modal-section-content" id="modal-love-content">
                                        <ul class="modal-features-list">
                                            <li>Easy Plug & Play Setup</li>
                                            <li>Up to 5G+ Speed</li>
                                            <li>Access Point Mode</li>
                                            <li>Full Coverage</li>
                                            <li>Browse without even being close to your router</li>
                                            <li>Faster Browsing Mode</li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="modal-section">
                                    <div class="modal-section-header" onclick="toggleModalSection('use')">
                                        <div class="modal-section-title">How to Use</div>
                                        <div class="modal-section-icon" id="modal-use-icon">+</div>
                                    </div>
                                    <div class="modal-section-content collapsed" id="modal-use-content">
                                        <p>1. Plug the extender into a power outlet halfway between your router and
                                            the area with poor WiFi coverage.</p>
                                        <p>2. Connect to the extender's network using your device's WiFi settings.
                                        </p>
                                        <p>3. Open a web browser and follow the setup wizard to configure the
                                            extender.</p>
                                        <p>4. Once configured, the extender will automatically connect to your
                                            existing network.</p>
                                    </div>
                                </div>
                                <div class="modal-section">
                                    <div class="modal-section-header" onclick="toggleModalSection('info')">
                                        <div class="modal-section-title">Additional Information</div>
                                        <div class="modal-section-icon" id="modal-info-icon">−</div>
                                    </div>
                                    <div class="modal-section-content" id="modal-info-content">
                                        <div class="modal-product-type">Product Type - T45Q</div>
                                        <div class="modal-delivery-info">Please note that delivery for this item
                                            will take between 2 to 5 working days from the date of payment
                                            confirmation.</div>
                                        <a href="#" class="modal-terms-link">Terms and Conditions apply</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include_once 'includes/footer.php'; ?>
<?php include_once 'includes/footer_end.php'; ?>
<script>
    $(document).ready(function() {
        var fadeInFadeOut = function(jQueryElement, timeout) {
            jQueryElement.fadeIn(1000);
            // setTimeout(function() {
            //     jQueryElement.fadeOut("slow");
            // }, timeout);
        };

        // Toast notification function
        function showToast(type, message, duration = 3000) {
            const toast = document.getElementById("toast");
            toast.textContent = message;
            toast.classList.add("show");
            if (type = "success") {
                toast.style.backgroundColor = "green"
            } else {
                toast.style.backgroundColor = "red"
            }
            setTimeout(() => {
                toast.classList.remove("show");
            }, duration);
        }

        // Show order details after successful order creation
        function showOrderDetails(data) {
            // document.getElementById('orderCustomerId').textContent = data.customer_id;
            // document.getElementById('orderOrderId').textContent = data.order_id;
            document.getElementById('orderOrderNumber').textContent = data.order_number;
            document.getElementById('orderCheckoutLink').textContent = data.checkout_link;
            document.getElementById('orderCheckoutLink').href = data.checkout_link;
            document.getElementById('orderDetails').style.display = 'block';
        }

        // Network data fetching
        let availableLocation = [];
        let categorizedPlans = {};

        async function getNetworkData() {
            try {
                const response = await fetch("https://eservice.fob.ng/apy/public/getplansWebsite");
                if (!response.ok) {
                    throw new Error("Network response was not ok");
                }

                const data = await response.json();

                // Extract unique locations
                availableLocation = [...new Set(data.UDATA.map((item) => item.PLAN_LOCATION.toLowerCase()))];

                // Build nested object: { Location: { residential: [], business: [] } }
                categorizedPlans = data.UDATA.reduce((acc, plan) => {
                    const location = plan.PLAN_LOCATION.toLowerCase();
                    const category = plan.PLAN_CATEGORY?.toLowerCase() === "home" ? "residential" : "business";
                    if (!acc[location]) {
                        acc[location] = {
                            residential: [],
                            business: []
                        };
                    }
                    acc[location][category].push(plan);
                    return acc;
                }, {});

                console.log("Available Locations:", availableLocation);
                console.log("Categorized Plans:", categorizedPlans);

                // Populate city dropdown
                const citySelect = document.getElementById("city");
                citySelect.innerHTML = '<option value="">Select Location</option>';
                availableLocation.forEach((location) => {
                    const option = document.createElement("option");
                    option.value = location;
                    option.textContent = location.charAt(0).toUpperCase() + location.slice(1);
                    citySelect.appendChild(option);
                });

                return {
                    availableLocation,
                    categorizedPlans
                };
            } catch (error) {
                console.error("Error fetching network data:", error);
                showToast("error", "Failed to load network data. Please try again.");
                return null;
            }
        }

        // Initialize network data on page load
        getNetworkData();

        // Step navigation and data storage
        const steps = ["step1", "step2", "step3", "step4"];
        let registrationData = {
            coverage: {},
            userDetails: {},
            selectedPlanType: null,
            selectedPlan: null,
            cart: [],
        };

        function showStep(stepId) {
            steps.forEach((id) => {
                const el = document.getElementById(id);
                if (el) el.classList.remove("active");
            });
            const target = document.getElementById(stepId);
            if (target) target.classList.add("active");
        }

        // Step 1: Network Coverage
        const coverageForm = document.getElementById("coverageForm");
        coverageForm.addEventListener("submit", function(e) {
            e.preventDefault();
            const formData = new FormData(coverageForm);
            const city = formData.get("city").trim().toLowerCase();
            const address = formData.get("address");

            if (!city || !address) {
                showToast("Please select a city and enter your address");
                return;
            }

            if (availableLocation.includes(city)) {
                registrationData.coverage = {
                    city,
                    address
                };
                document.getElementById("statusMessage").style.display = "block";
                document.getElementById("unavailableStatusMessage").style.display = "none";
                console.log("Coverage data:", registrationData.coverage);
                showStep("step2");
            } else {
                document.getElementById("statusMessage").style.display = "none";
                document.getElementById("unavailableStatusMessage").style.display = "block";
                showToast(`Sorry, we do not have coverage in ${city.charAt(0).toUpperCase() + city.slice(1)} yet.`);
            }
        });

        // Step 2: User Details
        const userDetailsForm = document.getElementById("userDetailsForm");
        userDetailsForm.addEventListener("submit", function(e) {
            e.preventDefault();
            const formData = new FormData(userDetailsForm);
            registrationData.userDetails = {
                name: formData.get("fullName"),
                company_name: formData.get("companyName"),
                phone: formData.get("phone"),
                additionalPhones: Array.from(document.querySelectorAll("#additionalPhones input")).map((input) => input.value).filter((val) => val),
                email: formData.get("email"),
                additionalEmails: Array.from(document.querySelectorAll("#additionalEmails input")).map((input) => input.value).filter((val) => val),
                address: formData.get("fullAddress"),
                source: formData.get("howDidYouHear"),
                comment: formData.get("comments"),
            };
            console.log("User details:", registrationData.userDetails);
            showStep("step3");
        });

        // Step 3: Service Plan Selection
        const plansContainer = document.getElementById("plansContainer");
        const categoryPlansSection = document.getElementById("categoryPlans");
        const plansTitle = document.getElementById("plansTitle");

        window.selectPlan = function(planType) {
            const city = registrationData.coverage.city;
            registrationData.selectedPlanType = planType;
            document.querySelectorAll(".plan-card").forEach((card) => card.classList.remove("selected"));
            document.querySelector(`.${planType}-card`).classList.add("selected");
            loadPlans(city, planType);
            categoryPlansSection.style.display = "block";
            categoryPlansSection.scrollIntoView({
                behavior: "smooth"
            });
        };

        window.loadPlans = function(location, category) {
            plansTitle.textContent = `${category.charAt(0).toUpperCase() + category.slice(1)} Plans For You in ${location.charAt(0).toUpperCase() + location.slice(1)}`;
            plansContainer.innerHTML = "";

            if (!categorizedPlans[location] || !categorizedPlans[location][category]) {
                plansContainer.innerHTML = "<p>No plans available for this selection.</p>";
                return;
            }

            const plans = categorizedPlans[location][category];
            plans.forEach((plan) => {
                const metadata = JSON.parse(plan?.METADATA || "{}");
                const card = document.createElement("div");
                card.className = "plan-detail-card";
                card.innerHTML = `
                <div class="plan-detail-header">
                    <h3 class="plan-name">${plan?.PLAN || "N/A"}</h3>
                    <p class="plan-speed">Up to ${metadata?.speed || "Check speed"}</p>
                    <div class="plan-price">
                        ₦${Number(plan?.AMOUNT).toLocaleString("en-NG", { minimumFractionDigits: 2, maximumFractionDigits: 2 }) || "N/A"}
                        <span class="plan-billing">per month</span>
                    </div>
                    <div class="plan-description">${plan?.PLAN_DESC || ""}</div>
                </div>
                <ul class="plan-features">
                    <li>${metadata?.download || "N/A"}</li>
                    <li>${metadata?.devices || "N/A"}</li>
                    <li>${metadata?.hd || "N/A"}</li>
                    <li>${metadata?.hd4k || "N/A"}</li>
                </ul>
                <button class="select-plan-btn" onclick="selectPlanDetails('${plan?.PLAN_ID}', '${category}')">Select Plan</button>
            `;
                plansContainer.appendChild(card);
            });
        };

        // window.selectPlanDetails = function (planId, planType) {
        //     const plan = categorizedPlans[registrationData.coverage.city][planType].find((p) => p?.PLAN_ID == planId);
        //     registrationData.selectedPlan = plan;
        //     registrationData.cart = registrationData.cart.map(item => ({
        //         ...item,
        //         quantity: item.id === 1 ? 1 : item.quantity // Auto-select "Premium Max+ Plan" or similar
        //     }));
        //     updateCart();
        //     showStep("step4");
        // };
        window.selectPlanDetails = function(planId, planType) {
            console.log("Plan details", planId, planType);
            console.log(
                categorizedPlans[registrationData.coverage.city][planType]
            );
            const plan = categorizedPlans[registrationData.coverage.city][
                planType
            ].find((p) => p?.PLAN_ID == planId);
            registrationData.selectedPlan = plan;
            console.log("The selected plan", plan);
            registrationData.cart = [{
                    name: `${plan?.PLAN} Plan`,
                    price: parseFloat(plan?.AMOUNT),
                    quantity: 1,
                    id: plan?.PLAN_ID,
                    plan_category: plan?.PLAN_CATEGORY,
                    plan_location: plan?.PLAN_LOCATION
                },
                {
                    name: "Installation",
                    price: parseFloat(plan?.OTC),
                    quantity: 1,
                    id: 1
                },
            ];
            updateCart();
            showStep("step4");
        };

        window.goBackToPlans = function() {
            categoryPlansSection.style.display = "none";
            document.querySelectorAll(".plan-card").forEach((card) => card.classList.remove("selected"));
            registrationData.selectedPlanType = null;
            registrationData.selectedPlan = null;
            document.querySelector(".plans-section").scrollIntoView({
                behavior: "smooth"
            });
        };

        window.changeLocation = function() {
            document.getElementById("categoryPlans").style.display = "none";
            document.getElementById("statusMessage").style.display = "none";
            document.getElementById("unavailableStatusMessage").style.display = "none";
            showStep("step1");
            document.querySelector(".main-content").scrollIntoView({
                behavior: "smooth"
            });
        };

        // Step 4: Checkout
        function updateCart() {
            const cartItems = document.getElementById("cartItems");
            const cartItemCount = document.getElementById("cartItemCount");
            const subtotalEl = document.getElementById("subtotal");
            const deliveryFeeEl = document.getElementById("deliveryFee");
            const totalEl = document.getElementById("total");
            const addressInput = document.getElementById("installationAddress");
            const addressDetails = document.getElementById("addressDetails");

            cartItems.innerHTML = "";
            let subtotal = 0;
            const activeItems = registrationData.cart.filter(item => item.quantity > 0);
            activeItems.forEach((item, index) => {
                subtotal += item.price * item.quantity;
                const cartItem = document.createElement("div");
                cartItem.className = "cart-item";
                cartItem.innerHTML = `
                <input type="checkbox" class="cart-item-checkbox" checked onchange="toggleCartItem(${index})" />
                <div class="cart-item-info">${item.name}</div>
                <div class="cart-item-price">₦${(item.price * item.quantity).toFixed(2)}</div>
            `;
                cartItems.appendChild(cartItem);
            });
            cartItemCount.textContent = activeItems.length;
            subtotalEl.textContent = `₦${subtotal.toFixed(2)}`;
            const deliveryFee = parseFloat(deliveryFeeEl.textContent.replace(/[^0-9.]/g, ""));
            totalEl.textContent = `₦${(subtotal + deliveryFee).toFixed(2)}`;
            addressInput.value = registrationData.userDetails.fullAddress || "";
            addressDetails.textContent = registrationData.coverage.address || "";
        }

        window.toggleCartItem = function(index) {
            const checkbox = document.querySelectorAll(".cart-item-checkbox")[index];
            if (!checkbox.checked) {
                registrationData.cart[index].quantity = 0;
                updateCart();
            }
        };

        window.switchTab = function(element, tabType) {
            document.querySelectorAll(".filter-tab").forEach((tab) => tab.classList.remove("active"));
            element.classList.add("active");
            const fiberoneSection = document.getElementById("fiberone-section");
            const thirdPartySection = document.getElementById("third-party-section");
            if (tabType === "all") {
                fiberoneSection.style.display = "block";
                thirdPartySection.style.display = "block";
            } else if (tabType === "fiberone") {
                fiberoneSection.style.display = "block";
                thirdPartySection.style.display = "none";
            } else if (tabType === "third-party") {
                fiberoneSection.style.display = "none";
                thirdPartySection.style.display = "block";
            }
        };

        window.selectPayment = function(element) {
            document.querySelectorAll(".payment-option").forEach((option) => option.classList.remove("selected"));
            element.classList.add("selected");
        };

        window.viewProduct = function(button) {
            const productCard = button.closest(".product-card");
            const productName = productCard.querySelector(".product-name").textContent;
            const productPrice = productCard.querySelector(".product-price").textContent;
            const modal = document.getElementById("productModal");
            modal.style.display = "flex";
            document.querySelector(".modal-product-title").textContent = productName;
            document.querySelector(".modal-price").textContent = productPrice;
        };

        window.closeModal = function() {
            document.getElementById("productModal").style.display = "none";
        };

        window.addToCart = function(button) {
            const productCard = button.closest(".product-card");
            const productId = productCard.dataset.productId;
            const productName = productCard.querySelector(".product-name").textContent;
            const productPrice = parseFloat(productCard.querySelector(".product-price").textContent.replace(/[^0-9.]/g, ""));
            const item = registrationData.cart.find(item => item.id == productId);
            if (item) {
                item.quantity += 1;
            } else {
                registrationData.cart.push({
                    name: productName,
                    price: productPrice,
                    quantity: 1,
                    id: productId
                });
            }
            updateCart();
            button.style.background = "#27ae60";
            button.textContent = "Added!";
            setTimeout(() => {
                button.style.background = "#e74c3c";
                button.textContent = "Add to Cart";
            }, 1500);
            showToast("success", `${productName} (₦${productPrice.toFixed(2)}) added to cart!`);
        };

        window.addToCartFromModal = function() {
            const productName = document.querySelector(".modal-product-title").textContent;
            const productPrice = parseFloat(document.querySelector(".modal-price").textContent.replace(/[^0-9.]/g, ""));
            const quantity = parseInt(document.getElementById("modalQuantity").value);
            const item = registrationData.cart.find(item => item.name === productName);
            if (item) {
                item.quantity += quantity;
            } else {
                registrationData.cart.push({
                    name: productName,
                    price: productPrice,
                    quantity: quantity
                });
            }
            updateCart();
            showToast("success", `${productName} (₦${productPrice.toFixed(2)}) added to cart!`);
            closeModal();
        };

        window.increaseModalQuantity = function() {
            const quantityInput = document.getElementById("modalQuantity");
            quantityInput.value = parseInt(quantityInput.value) + 1;
        };

        window.decreaseModalQuantity = function() {
            const quantityInput = document.getElementById("modalQuantity");
            const currentValue = parseInt(quantityInput.value);
            if (currentValue > 1) quantityInput.value = currentValue - 1;
        };

        window.toggleModalSection = function(sectionId) {
            const content = document.getElementById(`modal-${sectionId}-content`);
            const icon = document.getElementById(`modal-${sectionId}-icon`);
            if (content.classList.contains("collapsed")) {
                content.classList.remove("collapsed");
                icon.textContent = "−";
            } else {
                content.classList.add("collapsed");
                icon.textContent = "+";
            }
        };

        window.changeModalImage = function(src) {
            document.getElementById("modalMainImage").src = src;
        };

        function serializeFormData(formData) {
            const params = new URLSearchParams();

            // Handle products array
            // formData.products.forEach((product, index) => {
            //     Object.entries(product).forEach(([key, value]) => {
            //         params.append(`products[${index}][${key}]`, value);
            //     });
            // });

            formData.products.forEach((product) => {
                params.append("products[]", product.id);
            });
            params.append("product_information", JSON.stringify(formData.products));
            // Handle the rest of the fields
            Object.entries(formData).forEach(([key, value]) => {
                if (key !== "products") {
                    params.append(key, value);
                }
            });

            return params.toString();
        }




        window.proceedToPayment = function() {
            $('#succPan, #errPan').hide().empty();
            const selectedPayment = document.querySelector(".payment-option.selected");
            const paymentMethod = selectedPayment.textContent.trim();
            const activeItems = registrationData.cart.filter(item => item.quantity > 0);

            // Validate fields
            if (!registrationData.coverage.city || !registrationData.coverage.address) {
                showToast("error", "Please complete the network coverage step.");
                return;
            }
            if (!registrationData.userDetails.name || !registrationData.userDetails.email || !registrationData.userDetails.phone) {
                showToast("error", "Please complete all required user details.");
                return;
            }
            if (!registrationData.selectedPlan) {
                showToast("error", "Please select a service plan.");
                return;
            }
            if (activeItems.length === 0) {
                showToast("error", "Please select at least one product.");
                return;
            }

            $('#myLoading').modal({
                keyboard: false,
                show: true,
                backdrop: 'static'
            });

            const formDatum = {
                // coverage: registrationData.coverage,
                // userDetails: registrationData.userDetails,
                // selectedPlan: registrationData.selectedPlan,
                // cart: activeItems,
                // paymentMethod: paymentMethod

                products: activeItems,
                ...registrationData.userDetails
            };

            // Usage
            const serialized = serializeFormData(formDatum);
            console.log(serialized);
            var formData = serialized


            console.log("FormData", formDatum)


            $.ajax({
                url: 'ajax/add_customer_order.php',
                type: 'POST',
                data: formData,
                // contentType: 'application/json',
                dataType: 'json',
                success: function(response) {
                    console.log("response here", response)
                    $('#myLoading').modal('hide');
                    if (response.success) {
                        // $('#succPan').html(response.message).show();
                        showToast("success", `${response.message}`)
                        // fadeInFadeOut($('#succPan'));
                        document.querySelector(".checkout-button").disabled = true;
                        document.querySelector(".checkout-button").style.backgroundColor = "gray";
                        showOrderDetails(response)
                    } else {
                        showToast("error", `${response.message}`)
                        // $('#errPan').html(response.message).show();
                        // fadeInFadeOut($('#errPan'));
                    }
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    console.log("AJAX error:", textStatus, errorThrown, jqXHR.responseText);
                    $('#myLoading').modal('hide');
                    $('#errPan').text('Cannot contact server. Please try again later.').show();
                    fadeInFadeOut($('#errPan'));
                }
            });
        };

        // Additional phone/email fields
        let phoneCounter = 1;
        let emailCounter = 1;

        window.addPhoneField = function() {
            phoneCounter++;
            const container = document.getElementById("additionalPhones");
            const fieldDiv = document.createElement("div");
            fieldDiv.className = "additional-field";
            fieldDiv.innerHTML = `
            <input type="tel" class="form-input" placeholder="Additional Phone Number" name="phone${phoneCounter}">
            <button type="button" class="remove-field-btn" onclick="this.parentElement.remove()">Remove</button>
        `;
            container.appendChild(fieldDiv);
        };

        window.addEmailField = function() {
            emailCounter++;
            const container = document.getElementById("additionalEmails");
            fieldDiv.className = "additional-field";
            fieldDiv.innerHTML = `
            <input type="email" class="form-input" placeholder="Additional Email Address" name="email${emailCounter}">
            <button type="button" class="remove-field-btn" onclick="this.parentElement.remove()">Remove</button>
        `;
            container.appendChild(fieldDiv);
        };

        // Initialize
        if (registrationData.selectedPlan) {
            updateCart();
        }
        document.querySelector(".filter-tab.active") && switchTab(document.querySelector(".filter-tab.active"), "all");

        // Close modal when clicking outside
        document.addEventListener("click", function(event) {
            const modal = document.getElementById("productModal");
            if (event.target === modal) {
                closeModal();
            }
        });
    });
</script>